/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ChunkSwapChallenge
extends Challenge {
    private final Random random = new Random();
    private final Map<UUID, Long> lastSwapTimes = new HashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 5000L;
    private static final int MIN_CHUNK_OFFSET = 10;
    private static final int MAX_CHUNK_OFFSET = 1000;
    private static final int DEFAULT_CHUNK_OFFSET = 100;
    private class_1923 lastSourceChunkPos;
    private class_1937 lastSourceWorld;
    private class_1923 lastTargetChunkPos;
    private class_1937 lastTargetWorld;
    private static final String SETTING_CROSS_DIMENSIONAL = "cross_dimensional";
    private static final String SETTING_CHUNK_OFFSET = "chunk_offset";
    private static final boolean DEFAULT_CROSS_DIMENSIONAL = false;

    public ChunkSwapChallenge() {
        super("chunk_swap", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.chunk_swap.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.chunk_swap.description"), true, Challenge.MultiplayerStatus.MULTIPLAYER_COMPATIBLE);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_CROSS_DIMENSIONAL)) {
            ChallengeSettings.setBooleanOption(this.getId(), SETTING_CROSS_DIMENSIONAL, false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_CHUNK_OFFSET)) {
            ChallengeSettings.setIntOption(this.getId(), SETTING_CHUNK_OFFSET, 100);
        }
    }

    public boolean isCrossDimensionalEnabled() {
        return ChallengeSettings.getBooleanOption(this.getId(), SETTING_CROSS_DIMENSIONAL, false);
    }

    public void setCrossDimensionalEnabled(boolean enabled) {
        ChallengeSettings.setBooleanOption(this.getId(), SETTING_CROSS_DIMENSIONAL, enabled);
    }

    public int getChunkOffset() {
        return ChallengeSettings.getIntOption(this.getId(), SETTING_CHUNK_OFFSET, 100);
    }

    public void setChunkOffset(int offset) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_CHUNK_OFFSET, offset);
    }

    public static int getMinChunkOffset() {
        return 10;
    }

    public static int getMaxChunkOffset() {
        return 1000;
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.lastSwapTimes.clear();
        this.lastSourceChunkPos = null;
        this.lastSourceWorld = null;
        this.lastTargetChunkPos = null;
        this.lastTargetWorld = null;
    }

    @Override
    public void onDisable() {
        this.lastSwapTimes.clear();
        this.lastSourceChunkPos = null;
        this.lastSourceWorld = null;
        this.lastTargetChunkPos = null;
        this.lastTargetWorld = null;
    }

    public class_1923 getLastSwappedChunkPos() {
        return this.lastTargetChunkPos;
    }

    public class_1937 getLastSwappedWorld() {
        return this.lastTargetWorld;
    }

    public void onPlayerDamage(class_1657 player, class_1282 source, float amount) {
        if (!(player instanceof class_3222) || !(player.method_37908() instanceof class_3218)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3218 currentWorld = (class_3218)player.method_37908();
        long currentTime = System.currentTimeMillis();
        Long lastSwapTime = this.lastSwapTimes.get(player.method_5667());
        if (lastSwapTime != null && currentTime - lastSwapTime < 5000L) {
            return;
        }
        class_1923 pos = player.method_31476();
        currentWorld.method_8503().method_20493(() -> {
            class_3218 sourceWorld;
            if (this.isCrossDimensionalEnabled()) {
                switch (this.random.nextInt(3)) {
                    case 0: {
                        sourceWorld = currentWorld.method_8503().method_3847(class_1937.field_25179);
                        break;
                    }
                    case 1: {
                        sourceWorld = currentWorld.method_8503().method_3847(class_1937.field_25180);
                        break;
                    }
                    case 2: {
                        sourceWorld = currentWorld.method_8503().method_3847(class_1937.field_25181);
                        break;
                    }
                    default: {
                        sourceWorld = currentWorld.method_8503().method_3847(class_1937.field_25179);
                        break;
                    }
                }
            } else {
                sourceWorld = currentWorld;
            }
            if (sourceWorld != null) {
                class_2338 blockPos2;
                int z;
                int y;
                int x;
                int maxOffset = this.getChunkOffset();
                int randomX = pos.field_9181 + this.random.nextInt(maxOffset * 2) - maxOffset;
                int randomZ = pos.field_9180 + this.random.nextInt(maxOffset * 2) - maxOffset;
                class_1923 sourcePos = new class_1923(randomX, randomZ);
                this.lastSourceChunkPos = pos;
                this.lastSourceWorld = currentWorld;
                this.lastTargetChunkPos = sourcePos;
                this.lastTargetWorld = sourceWorld;
                class_2818 sourceChunk = sourceWorld.method_8497(sourcePos.field_9181, sourcePos.field_9180);
                class_2818 currentChunk = currentWorld.method_8497(pos.field_9181, pos.field_9180);
                HashMap<class_2338, class_2680> currentBlocksMap = new HashMap<class_2338, class_2680>();
                HashMap<class_2338, class_2680> sourceBlocksMap = new HashMap<class_2338, class_2680>();
                for (x = 0; x < 16; ++x) {
                    for (y = -64; y < 320; ++y) {
                        for (z = 0; z < 16; ++z) {
                            try {
                                blockPos2 = new class_2338(pos.method_8326() + x, y, pos.method_8328() + z);
                                currentBlocksMap.put(new class_2338(x, y, z), currentChunk.method_8320(blockPos2));
                                continue;
                            }
                            catch (Exception blockPos2) {
                                // empty catch block
                            }
                        }
                    }
                }
                for (x = 0; x < 16; ++x) {
                    for (y = -64; y < 320; ++y) {
                        for (z = 0; z < 16; ++z) {
                            try {
                                blockPos2 = new class_2338(sourcePos.method_8326() + x, y, sourcePos.method_8328() + z);
                                sourceBlocksMap.put(new class_2338(x, y, z), sourceChunk.method_8320(blockPos2));
                                continue;
                            }
                            catch (Exception blockPos3) {
                                // empty catch block
                            }
                        }
                    }
                }
                for (x = 0; x < 16; ++x) {
                    for (y = -64; y < 320; ++y) {
                        for (z = 0; z < 16; ++z) {
                            try {
                                class_2338 currentBlockPos = new class_2338(pos.method_8326() + x, y, pos.method_8328() + z);
                                currentWorld.method_8652(currentBlockPos, class_2246.field_10124.method_9564(), 3);
                                class_2338 sourceBlockPos = new class_2338(sourcePos.method_8326() + x, y, sourcePos.method_8328() + z);
                                sourceWorld.method_8652(sourceBlockPos, class_2246.field_10124.method_9564(), 3);
                                continue;
                            }
                            catch (Exception currentBlockPos) {
                                // empty catch block
                            }
                        }
                    }
                }
                for (class_2338 relativePos : sourceBlocksMap.keySet()) {
                    try {
                        class_2338 worldPos = new class_2338(pos.method_8326() + relativePos.method_10263(), relativePos.method_10264(), pos.method_8328() + relativePos.method_10260());
                        currentWorld.method_8652(worldPos, (class_2680)sourceBlocksMap.get(relativePos), 3);
                    }
                    catch (Exception worldPos) {}
                }
                for (class_2338 relativePos : currentBlocksMap.keySet()) {
                    try {
                        class_2338 worldPos = new class_2338(sourcePos.method_8326() + relativePos.method_10263(), relativePos.method_10264(), sourcePos.method_8328() + relativePos.method_10260());
                        sourceWorld.method_8652(worldPos, (class_2680)currentBlocksMap.get(relativePos), 3);
                    }
                    catch (Exception worldPos) {}
                }
                for (int x2 = 0; x2 < 16; ++x2) {
                    for (int y2 = -64; y2 < 320; ++y2) {
                        for (int z2 = 0; z2 < 16; ++z2) {
                            try {
                                class_2338 currentPos = new class_2338(pos.method_8326() + x2, y2, pos.method_8328() + z2);
                                currentWorld.method_14178().method_14128(currentPos);
                                class_2338 sourcePos2 = new class_2338(sourcePos.method_8326() + x2, y2, sourcePos.method_8328() + z2);
                                sourceWorld.method_14178().method_14128(sourcePos2);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        });
        this.lastSwapTimes.put(player.method_5667(), currentTime);
    }
}

